-- User Management Tables
-- Migration 009: Add User Management Tables

CREATE TABLE IF NOT EXISTS Users (
    UserID INTEGER PRIMARY KEY AUTOINCREMENT,
    Username TEXT NOT NULL UNIQUE,
    FullName TEXT NOT NULL,
    PasswordHash TEXT NOT NULL,
    Email TEXT,
    Phone TEXT,
    IsActive INTEGER NOT NULL DEFAULT 1,
    IsAdmin INTEGER NOT NULL DEFAULT 0,
    CreatedAt TEXT NOT NULL DEFAULT (datetime('now')),
    LastLogin TEXT
);

CREATE TABLE IF NOT EXISTS Roles (
    RoleID INTEGER PRIMARY KEY AUTOINCREMENT,
    RoleName TEXT NOT NULL UNIQUE,
    Description TEXT,
    IsActive INTEGER NOT NULL DEFAULT 1,
    CreatedAt TEXT NOT NULL DEFAULT (datetime('now'))
);

CREATE TABLE IF NOT EXISTS UserRoles (
    UserRoleID INTEGER PRIMARY KEY AUTOINCREMENT,
    UserID INTEGER NOT NULL,
    RoleID INTEGER NOT NULL,
    FOREIGN KEY (UserID) REFERENCES Users(UserID) ON DELETE CASCADE,
    FOREIGN KEY (RoleID) REFERENCES Roles(RoleID) ON DELETE CASCADE,
    UNIQUE(UserID, RoleID)
);

CREATE TABLE IF NOT EXISTS Permissions (
    PermissionID INTEGER PRIMARY KEY AUTOINCREMENT,
    PermissionName TEXT NOT NULL,
    PageName TEXT NOT NULL,
    Description TEXT
);

CREATE TABLE IF NOT EXISTS RolePermissions (
    RolePermissionID INTEGER PRIMARY KEY AUTOINCREMENT,
    RoleID INTEGER NOT NULL,
    PermissionID INTEGER NOT NULL,
    CanView INTEGER NOT NULL DEFAULT 1,
    CanAdd INTEGER NOT NULL DEFAULT 0,
    CanEdit INTEGER NOT NULL DEFAULT 0,
    CanDelete INTEGER NOT NULL DEFAULT 0,
    FOREIGN KEY (RoleID) REFERENCES Roles(RoleID) ON DELETE CASCADE,
    FOREIGN KEY (PermissionID) REFERENCES Permissions(PermissionID) ON DELETE CASCADE,
    UNIQUE(RoleID, PermissionID)
);

-- Insert default admin user (password: admin123)
INSERT OR IGNORE INTO Users (Username, FullName, PasswordHash, IsActive, IsAdmin) 
VALUES ('admin', 'مدير النظام', 'jGl25bVBBBW96Qi9Te4V37Fnqchz/Eu4qB9vKrRIqRg=', 1, 1);

-- Insert default roles
INSERT OR IGNORE INTO Roles (RoleName, Description) VALUES ('مدير النظام', 'صلاحيات كاملة للنظام');
INSERT OR IGNORE INTO Roles (RoleName, Description) VALUES ('مدير المدرسة', 'إدارة شؤون المدرسة');
INSERT OR IGNORE INTO Roles (RoleName, Description) VALUES ('مدير المسجد', 'إدارة شؤون المسجد');
INSERT OR IGNORE INTO Roles (RoleName, Description) VALUES ('معلم', 'صلاحيات المعلم');
INSERT OR IGNORE INTO Roles (RoleName, Description) VALUES ('مستخدم عادي', 'عرض فقط');

-- Insert default permissions for each page
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('لوحة التحكم', 'DashboardPage', 'الوصول للوحة التحكم');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('الطلاب', 'StudentsPage', 'إدارة الطلاب');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('المعلمون', 'TeachersPage', 'إدارة المعلمين');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('الفصول', 'ClassesPage', 'إدارة الفصول');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('الدروس', 'LessonsPage', 'إدارة الدروس');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('الحضور', 'AttendancePage', 'إدارة الحضور');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('التحفيظ', 'MemorizationPage', 'متابعة التحفيظ');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('التقييمات', 'AssessmentsPage', 'إدارة التقييمات');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('اشتراكات الطلاب', 'PaymentsPage', 'إدارة المدفوعات');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('الإدارة المالية', 'FinancePage', 'الإدارة المالية');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('التقارير', 'ReportsPage', 'عرض التقارير');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('الإعدادات', 'SettingsPage', 'إعدادات النظام');
INSERT OR IGNORE INTO Permissions (PermissionName, PageName, Description) VALUES ('إدارة المستخدمين', 'UsersPage', 'إدارة المستخدمين والصلاحيات');

-- Assign admin role to default admin user
INSERT OR IGNORE INTO UserRoles (UserID, RoleID) VALUES (1, 1);

-- Give admin role full permissions on all pages
INSERT OR IGNORE INTO RolePermissions (RoleID, PermissionID, CanView, CanAdd, CanEdit, CanDelete)
SELECT 1, PermissionID, 1, 1, 1, 1 FROM Permissions;
